rm(list=ls())
library(memisc)
source("me-syntactic-sugar.R")

# Diese SPSS-Datei ist nicht beigefgt, sie ist von GESIS erhltlich.
ZA5702 <- spss.system.file("Daten/ZA5702_v2-0-0.sav")

# Datenstze in Latin1-Codierung mssen in die native Codierung konvertiert werden,
# das ist hier aber nicht ntig
# ZA5702 <- Iconv(ZA5702,from="latin1")

# Hier werden die Variablen ausgewhlt, die weiter verwendet werden sollen.
gles2013work <- subset(ZA5702,
                       select=c(
                         year,
                         welle=survey,
                         lfd=lfdn,
                         dat=datum,
                         ragelt18,
                         w_ow,
                         w_tran,
                         geschl=vn1,
                         #alter=vn542,
                         geburt.mon = vn2b,
                         geburt.jahr = vn2c,
                         #
                         abs.wahlbet = v10,
                         wahlbet = n10,
                         #
                         wahlabs1 = v11aa,
                         wahlabs2 = v11ba,
                         #
                         wahlbrief1 = v12aa,
                         wahlbrief2 = v12ba,
                         #
                         sich.wahlabs = v13,
                         #
                         wahlent1 = n11aa,
                         wahlent2 = n11ba,
                         #
                         parteineigung = vn119a,
                         parteing_strk = vn120,
                         parteing_dauer = vn121,
                         parteing_art = vn122,
                         #
                         partngvater = vn156a,
                         partngmutter = vn157a,
                         #
                         religzugh = vn228,
                         kirchg = vn193,
                         religios = vn194,
                         schulabschluss = vn163,
                         #
                         bula12 = bl,
                         #
                         bula_geb = vn197,
                         #
                         gewerkschaft_befr = vn213a,
                         gewerkschaft_hh = vn214,
                         #
                         ostwest
                         ))

# Die Erst- und Zweitstimmen-Variablen werden aus den einzelnen
# Frangen zusammengesetzt (je nach Wahlbeteiligungsabsicht und 
# schon durchgefhrter Briefwahl)
gles2013work <- within(gles2013work,{

  erststimme <- cases(
              welle == 1 & abs.wahlbet == 6 -> wahlbrief1,
              welle == 1 & abs.wahlbet %in% 4:5 -> 900,
              welle == 1 & abs.wahlbet %in% 1:3 -> wahlabs1,
              welle == 2 & wahlbet ==1 -> wahlent1,
              welle == 2 & wahlbet ==2 -> 900
            )

  zweitstimme <- cases(
              welle == 1 & abs.wahlbet == 6 -> wahlbrief2,
              welle == 1 & abs.wahlbet %in% 4:5 -> 900,
              welle == 1 & abs.wahlbet %in% 1:3 -> wahlabs2,
              welle == 2 & wahlbet ==1 -> wahlent2,
              welle == 2 & wahlbet ==2 -> 900
            )
  
  erststimme <- recode(as.item(erststimme),
                      "CDU/CSU"   =  1 <- 1,
                      "SPD"       =  2 <- 4,
                      "FDP"       =  3 <- 5,
                      "Grne"     =  4 <- 6,
                      "Linke"     =  5 <- 7,
                      "NPD"       =  6 <- 206,
                      "Piraten"   =  7 <- 215,
                      "AfD"       =  8 <- 322,
                      "Andere"    = 10 <- 801,
                      "Nichtwahl" = 90 <- 900,
                      "WN"        = 98 <- -98,
                      "KA"        = 99 <- -99
                  )
  zweitstimme <- recode(as.item(zweitstimme),
                      "CDU/CSU"   =  1 <- 1,
                      "SPD"       =  2 <- 4,
                      "FDP"       =  3 <- 5,
                      "Grne"     =  4 <- 6,
                      "Linke"     =  5 <- 7,
                      "NPD"       =  6 <- 206,
                      "Piraten"   =  7 <- 215,
                      "AfD"       =  8 <- 322,
                      "Andere"    = 10 <- 801,
                      "Nichtwahl" = 90 <- 900,
                      "WN"        = 98 <- -98,
                      "KA"        = 99 <- -99
                  )
  
   missing.values(erststimme) <- 98:99
   missing.values(zweitstimme) <- 98:99
   measurement(erststimme) <- "nominal"
   measurement(zweitstimme) <- "nominal"

   description(erststimme) <- "Erststimme: Wahlabsicht bzw. Rckerinnerung"
   description(zweitstimme) <- "Zweitstimme: Wahlabsicht bzw. Rckerinnerung"
   
   labels(dat) <- NULL
   measurement(dat) <- "interval"

   measurement(geburt.jahr) <- "interval" 
   measurement(geburt.mon) <- "interval" 
   
   monat <- dat%/%10000       %#% "Monat der Befragung"
   tag <- (dat%%10000)%/%100  %#% "Monatstag der Befragung"
   jahr <- 2000 + dat%%100    %#% "Jahr der Befragung"
   
   alter <- jahr*100-geburt.jahr*100
   alter <- alter+ifelse(geburt.mon>0,100*(monat-geburt.mon)/12,0)
   alter <- alter%/%100       %#% "Alter Befr."

   foreach(pn = c(parteineigung,partngvater,partngmutter),{
       pn <- recode(pn,
                    "Keine"     =  0 <- 808,
                    "CDU/CSU"   =  1 <- 1:3,
                    "SPD"       =  2 <- 4,
                    "FDP"       =  3 <- 5,
                    "Grne"     =  4 <- 6,
                    "Linke"     =  5 <- 7,
                    "Andere"    = 10 <- c(206,215,322,801),
                    otherwise="copy"
                    )
       valid.values(pn) <- c(0:5,10)
   })
   parteing_artd <- recode(parteing_art)
   
   religzugh <- recode(religzugh,
                       Protestant = 1 <- 1:2,
                       Katholisch = 2 <- 3,
                       Andere     = 3 <- 4:5,
                       Keine      = 4 <- 9)

   kirchg <- recode(kirchg,
                    Nie                = 1 <- 1,
                    "Einmal im Jahr"   = 2 <- 2,
                    "Mehrmals im Jahr" = 3 <- 3,
                    "fter"            = 4 <- 4:7)

   schulabschluss <- recode(schulabschluss,
                            "Hauptschule"       = 1 <- 2,
                            "Realschule"        = 2 <- 3,
                            "Abitur/Fachabitur" = 3 <- 4:5)

   gewerkschaft <- cases(
       "Gewerkschaftsmtgl. selbst" = 3 <- gewerkschaft_befr %in% 1:3,
       "Gewerkschaftsmtgl. im Haushalt" = 2 <- gewerkschaft_hh == 1,
       "Kein Gewerkschaftsmitgl" = 1 <- TRUE
   ) %#% "Gewerkschaftsmitgliedschaft"
   
})                         

# Ein Teildatensatz nur mit den ISCO-Codes
gles2013isco <- subset(ZA5702,
                       select=c(
                         
                         isco88b = vn168,
                         isco88b.f = vn227,
                         isco88p = vn184,
                         isco88p.f = vn189,
                         
                         aufsicht = vn170,
                         aufsicht.f = vn177,
                         aufsicht.p = vn185,
                         aufsicht.pf = vn190,

                         beruf = vn167,
                         beruf.f = vn176,
                         beruf.p = vn183,
                         beruf.pf = vn188
                         ))


# Anpassung der ISCO-Codes nach Ganzeboom
gles2013isco <- within(gles2013isco,{
              
      foreach(x = c(beruf,beruf.f,beruf.p,beruf.pf),
              y = c(selbstnd.b,selbstnd.bf,selbstnd.p,selbstnd.pf),
              y <- x %in% c(41:43,51:53))
              
      foreach(a = c(aufsicht,aufsicht.f,aufsicht.p,aufsicht.pf),
              b = c(beruf,beruf.f,beruf.p,beruf.pf),
              s = c(selbstnd.b,selbstnd.bf,selbstnd.p,selbstnd.pf),
              y = c(nsuperv,nsuperv.f,nsuperv.p,nsuperv.pf),{
                y <- recode(a,1->1,2->0)
                y[s & b %in% c(41,51)] <- 0
                y[s & b %in% c(42,52)] <- 5
                y[s & b %in% c(43,53)] <- 11
              })
})

# Dieses R-Script enthlt Helfer-Funktionen fr die Konvertierung
# von ISCO-Codierung in das EGP-Klassenschema
source("isco88-2egp.R")

# Dieses R-Script enthlt Helfer-Funktionen fr die Konvertierung
# von den traditionellen Berufsgruppen in ein quasi-EGP-Klassenschema
source("pseudoclass.R")

# Umrechnung der ISCO-Codes und Berufsgruppen in das EGP-Klassenschema
gles2013isco <- within(gles2013isco,{

  foreach(i   = c(isco88b,isco88b.f,isco88p,isco88p.f),
          s   = c(selbstnd.b,selbstnd.bf,selbstnd.p,selbstnd.pf),
          nsv = c(nsuperv,nsuperv.f,nsuperv.p,nsuperv.pf),
          e   = c(EGPb,EGPb.f,EGPp,EGPp.f),
          {
              e <- isco88.2egp(isco88=i,sempl=s,nsv=nsv)
          })
          
  EGPb1 <- ifelse(is.valid(EGPb),EGPb,EGPb.f) %#% "EGP-Klasse Befragte/r"
  EGPp1 <- ifelse(is.valid(EGPp),EGPp,EGPp.f) %#% "EGP-Klasse Partner/in"
  
  EGP <- ifelse(is.valid(EGPb1),EGPb1,EGPp1) %#% "EGP-Klasse Befr. oder Partner/in"
  EGPdom <- cases(
    is.valid(EGPb1) & is.valid(EGPp1) & (EGPb1 > EGPp1)  -> EGPp1,
    is.valid(EGPb1) & is.valid(EGPp1) & (EGPb1 <= EGPp1) -> EGPb1,
    is.valid(EGPb1) & !is.valid(EGPp1)                   -> EGPb1,
    !is.valid(EGPb1) & is.valid(EGPp1)                   -> EGPp1
    ) %#% "EGP-Klasse Befr. oder Partner/in, Dominanzprinzip"
  
  foreach(x=c(EGP,EGPdom,EGPb,EGPb.f,EGPp,EGPp.f,EGPb1,EGPp1),{
    labels(x) <- structure(1:11,names=EGPlabels_romdig) 
  })
  
  foreach(Beruf=c(beruf,beruf.f,beruf.p,beruf.pf),
          Class7=c(Class7R,Class7RF,Class7P,Class7PF),{
            Class7 <- BerufClass13(Beruf)
          })

  description(Class7R) <- "Siebenstufiges Berufsklassenschema, Befragte/r"
  description(Class7P) <- "Siebenstufiges Berufsklassenschema, Partner/in"

  description(Class7RF) <- "Siebenstufiges Berufsklassenschema, Frherer Beruf Befragte/r"
  description(Class7PF) <- "Siebenstufiges Berufsklassenschema, Frherer Beruf Partner/in"

  Class7 <- ifelse(is.valid(Class7R),Class7R,Class7P) %#%
  "Siebenstufiges Berufsklassenschema, Befragte/r oder Partner/in"

  Class7r <- ifelse(is.valid(Class7R),Class7R,Class7RF)
  Class7p <- ifelse(is.valid(Class7P),Class7P,Class7PF)

  Class7a <- ifelse(is.valid(Class7r),Class7r,Class7p) %#%
  "Siebenstufiges Berufsklassenschema, Befragte/r oder Partner/in, einsch frh. Beruf"

  labels(Class7) <- labels(Class7R)
  labels(Class7a) <- labels(Class7R)
})

# Auswahl der weiter zu verwendenden Variablen
gles2013EGP <- subset(gles2013isco,
  select=c(EGP,EGPdom,EGPb1,EGPp1,
           Class7R,Class7P,Class7RF,Class7PF,
           Class7,Class7a
          ))

gles2013EGP <- rename(gles2013EGP,
			EGPb1="EGPb",
			EGPp1="EGPp"
			)          
			
# Die beiden Teildatenstze werden zusammengefhrt
gles2013work.names <- c(names(gles2013work),names(gles2013EGP))
gles2013work <- cbind(gles2013work,gles2013EGP)
names(gles2013work) <- gles2013work.names # Das hier sollte bei
# knftigen memisc-Versionen nicht mehr ntig sein ...

Write(codebook(gles2013work),
           file="gles2013work-cdbk.txt")

save(gles2013work,EGPlabels_romdig,EGPlabels_long,
     file="gles2013work.RData")
